-- update submit application msg event recipient change shortName to printName

set sql_safe_updates=0;

SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_RECIPIENTS');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
        T1.id AS ID,
        T3.`salutationName` AS SALUTATION_NAME,
        T8.`salutationName` AS PARENT_SALUTATION_NAME,
        T2.`firstName` AS FIRST_NAME,
        T2.`middleName` AS MIDDLE_NAME,
		T2.`printName` AS STUDENT_PRINT_NAME,
        T2.`lastName` AS LAST_NAME,
        T7.`emailId` AS EMAIL_ID,
        T7.`mobileNumber` AS MOBILE_NO,
        T1.`code` AS APPLICATION_CODE,
        T7.`firstName` AS PARENT_FIRSTNAME,
        T7.`lastName` AS PARENT_LASTNAME,
		T7.`printName` AS PARENT_PRINT_NAME,
        T7.`mobileCountryCode` AS MOBILE_CODE   
    FROM
        application T1
            LEFT OUTER JOIN
        applicant_person T2 ON T1.applicantPersonId = T2.id
            LEFT JOIN
        salutations T3 ON T3.id = T2.salutationId
            LEFT OUTER JOIN
        external_user_association T5 ON T5.applicationId = T1.id
            LEFT OUTER JOIN
        external_users T4 ON T4.id = T5.externalUserId
            LEFT OUTER JOIN
        applicant_person_relationships T6 ON T6.applicantPersonId = T2.id
            LEFT OUTER JOIN
        applicant_person T7 ON T7.id = T6.relatedApplicantPersonId
            LEFT JOIN
        salutations T8 ON T8.id = T7.salutationId
    WHERE
        T1.id IN (namedParams)
            AND T6.relationship = \'FATHER\'
            ',
    `jsonString` = '{
        "id": 1,
        "searchResultViewColumns": [
            {
                "id": 3,
                "value": "firstName",
                "resultKey": "FIRST_NAME",
                "displayCode": "",
                "displayOrder": 2
            },
            {
                "id": 4,
                "value": "middleName",
                "resultKey": "MIDDLE_NAME",
                "displayCode": "",
                "displayOrder": 3
            },
            {
                "id": 5,
                "value": "lastName",
                "resultKey": "LAST_NAME",
                "displayCode": "",
                "displayOrder": 4
            },
            {
                "id": 6,
                "value": "emailId",
                "resultKey": "EMAIL_ID",
                "displayCode": "",
                "displayOrder": 5
            },
            {
                "id": 7,
                "value": "mobileNumber",
                "resultKey": "MOBILE_NO",
                "displayCode": "",
                "displayOrder": 6
            },
            {
                "id": 8,
                "value": "code",
                "resultKey": "APPLICATION_CODE",
                "displayCode": "",
                "displayOrder": 7
            },		 
    		{
                "id": 9,
                "value": "firstName",
                "resultKey": "PARENT_FIRSTNAME",
                "displayCode": "",
                "displayOrder": 8
            },
    		{
                "id": 10,
                "value": "lastName",
                "resultKey": "PARENT_LASTNAME",
                "displayCode": "",
                "displayOrder": 9
            },
    		{
                "id": 11,
                "value": "salutationName",
                "resultKey": "PARENT_SALUTATION_NAME",
                "displayCode": "",
                "displayOrder": 10
            },
    		{
                "id": 12,
                "value": "salutationName",
                "resultKey": "SALUTATION_NAME",
                "displayCode": "",
                "displayOrder": 11
            },
    		{
                "id": 13,
                "value": "shortName",
                "resultKey": "STUDENT_PRINT_NAME",
                "displayCode": "",
                "displayOrder": 12
            },
    		{
                "id": 14,
                "value": "shortName",
                "resultKey": "PARENT_PRINT_NAME",
                "displayCode": "",
                "displayOrder": 13
            }
        ]
    }'
WHERE
    `dataProviderId` = @dtproviderId;

-- update sms template of external user velocity

SET @externalUserDtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='ADD_EXTERNAL_USER_VELOCITY_RECIPIENT_INFO');


UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = 'SELECT 
        T1.id AS ID,
        T4.`firstName` AS FIRST_NAME,
        T4.`lastName` AS LAST_NAME,
		T4.`printName` AS STUDENT_PRINT_NAME,
        T6.`emailId` AS EMAIL_ID,
        T6.`mobileNumber` AS MOBILE_NO,
        T6.`mobileCountryCode` AS MOBILE_CODE,
        T6.`firstName` AS PARENT_FIRSTNAME,
        T6.`lastName` AS PARENT_LASTNAME, 
		T6.`printName` AS PARENT_PRINT_NAME,   
    	T3.`code` as APPLICATION_CODE
    FROM
        external_users T1
            LEFT JOIN
        external_user_association T2 ON T2.externalUserId = T1.id
            LEFT JOIN
        application T3 ON T3.id = T2.applicationId
            LEFT JOIN
        applicant_person T4 ON T4.id = T3.applicantPersonId
            LEFT JOIN
        applicant_person_relationships T5 ON T5.applicantPersonId = T4.id
            LEFT JOIN
        applicant_person T6 ON T6.id = T5.relatedApplicantPersonId  
    WHERE
        T1.id IN (namedParams)
            AND T5.relationship = \'FATHER\'
            ',
    `jsonString` = '{
        "id": 1,
        "searchResultViewColumns": [
            {
                "id": 3,
                "value": "firstName",
                "resultKey": "FIRST_NAME",
                "displayCode": "",
                "displayOrder": 2
            },
            {
                "id": 4,
                "value": "middleName",
                "resultKey": "MIDDLE_NAME",
                "displayCode": "",
                "displayOrder": 3
            },
            {
                "id": 5,
                "value": "lastName",
                "resultKey": "LAST_NAME",
                "displayCode": "",
                "displayOrder": 4
            },
            {
                "id": 6,
                "value": "emailId",
                "resultKey": "EMAIL_ID",
                "displayCode": "",
                "displayOrder": 5
            },
            {
                "id": 7,
                "value": "mobileNumber",
                "resultKey": "MOBILE_NO",
                "displayCode": "",
                "displayOrder": 6
            },
            {
                "id": 8,
                "value": "code",
                "resultKey": "APPLICATION_CODE",
                "displayCode": "",
                "displayOrder": 7
            },		 
    		{
                "id": 9,
                "value": "firstName",
                "resultKey": "PARENT_FIRSTNAME",
                "displayCode": "",
                "displayOrder": 8
            },
    		{
                "id": 10,
                "value": "lastName",
                "resultKey": "PARENT_LASTNAME",
                "displayCode": "",
                "displayOrder": 9
            },
    		{
                "id": 11,
                "value": "shortName",
                "resultKey": "STUDENT_PRINT_NAME",
                "displayCode": "",
                "displayOrder": 10
            },
    		{
                "id": 12,
                "value": "shortName",
                "resultKey": "PARENT_PRINT_NAME",
                "displayCode": "",
                "displayOrder": 11
            }
        ]
    }'
WHERE
    `dataProviderId` = @externalUserDtproviderId;

set sql_safe_updates=1;